#!/bin/bash

# Komut satırından da verilebilir; yoksa interaktif sor
if [ -n "$1" ]; then
  INPUT_UID="$1"
else
  read -p "Lütfen UID girin: " INPUT_UID
fi

QRLOCK_DIR="$HOME/.qrlock"
UID_FILE="$QRLOCK_DIR/uid.txt"

# .qrlock dizini yoksa hiçbir şey yapma, varsa dosyayı üzerine yaz
if [ -d "$QRLOCK_DIR" ]; then
  # Sadece girilen UID'yi dosyaya yazar (sonunda yeni satır olmaması için printf kullandım)
  printf '%s' "$INPUT_UID" > "$UID_FILE"
  echo "UID başarıyla kaydedildi: $UID_FILE"
else
  echo "HATA: $QRLOCK_DIR dizini bulunamadı. İşlem yapılmadı."
  exit 1
fi

